package joss.services;

import joss.interfaces.*;
import joss.exceptions.*;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.beans.*;

/**
 * Title:        Java Operating System Show
 * Description:  Example for the OS course at ZCU FAV KIV
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */

public class TextConsoleWindow extends JFrame
                               implements ITextConsoleIface, Runnable{
  private IInput fReader = null;
  JScrollPane jScrollPane1 = new JScrollPane();
  JTextArea fConsole = new JTextArea();

  public TextConsoleWindow() {
  /*  try {
      jbInit();
      setSize(500, 300);
      show();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    */
  }
  private void jbInit() throws Exception {
    fConsole.setToolTipText("");
    fConsole.addKeyListener(new java.awt.event.KeyAdapter() {
      public void keyTyped(KeyEvent e) {
        fConsole_keyTyped(e);
      }
    });
    fConsole.setFont(new java.awt.Font("Monospaced", 0, 12));
    fConsole.setAutoscrolls(true);
    this.getContentPane().add(jScrollPane1, BorderLayout.CENTER);
    jScrollPane1.getViewport().add(fConsole, null);
  }

  public synchronized void setReader(IInput aReader) {
    fReader = aReader;
    if (fReader == null) {
      dispose();
    }
  }

  public synchronized void writeData(Object[] o) throws EJOSSError {

    /* We will output all objects as new lines into the fConsole.*/

    try {
      for (int i=0; i<o.length; i++) {
          fConsole.append(o[i].toString());
      fConsole.setCaretPosition(fConsole.getLineEndOffset(fConsole.getLineCount())-1);
       }
    } catch (Throwable a) {
      throw(new EJOSSError("writeData["+
                           a.getClass().getName()+": "+a.getMessage()+"]"));
    }
  }

  void fConsole_keyTyped(KeyEvent e) {
    //if user typed the Enter key, then we will take this as input of current
    //line
    try {
      if ((e.getKeyChar() == KeyEvent.VK_ENTER) && (fReader !=null)) {
        int ln = fConsole.getLineOfOffset(fConsole.getCaretPosition())-1;
        int strt = fConsole.getLineStartOffset(ln);
        Object[] o = new Object[1];

        o[0] = fConsole.getText(strt, fConsole.getLineEndOffset(ln)-strt-1);
        fReader.onReadData(o);
      }
    } catch (Throwable a) {}

  }
  void fConsole_keyPressed(KeyEvent e) {

  }
  void fConsole_keyReleased(KeyEvent e) {

  }

  public void run() {
  try {
      jbInit();
      setSize(500, 300);
      show();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

}