package joss.runtime.cshell;

/**
 * Title:        Java Operating System Show
 * Description:  Example for the OS course at ZCU FAV KIV
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */

import joss.interfaces.*;
import joss.exceptions.*;

import java.io.*;

/**
 * This clas is intended for out-redirection to disk.
 */

public class DiskOut implements IOutput{

  private BufferedWriter out = null;

  public DiskOut(String aFile) throws IOException {
    out = new BufferedWriter(new FileWriter(new File(aFile)));
  }

  public void writeData(Object[] o) throws EJOSSError
  {
   try {
     for (int i=0; i<o.length; i++)
       out.write(o[i].toString());
     out.flush();
   } catch(Throwable a) {
     throw new EJOSSError(a.getClass().getName()+": "+a.getLocalizedMessage());
   }
  }

  public void finalize() {
    try {
      out.close();
      out = null;
      super.finalize();
    } catch (Throwable a) {a.printStackTrace();}
  }
}