package joss.runtime.cshell;

/**
 * Title:        Java Operating System Show
 * Description:  Example for the OS course at ZCU FAV KIV
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */

import joss.interfaces.*;
import joss.exceptions.*;
import joss.services.*;
import joss.runtime.*;


import java.net.*;

public class CShell implements IJOSSApp, mconst, IInput {

  private ITextConsoleIface fConsole;
  private IServiceManager fSMgr;
  private IJOSSApp fJOSSApp;
  private FileEx fFile;

  public void main(IStartupInfo si) {
    //1. Retain access to services
    fSMgr = si.getServiceManager();

    //2. Create and setup console
    fConsole = (ITextConsoleIface)
               fSMgr.getServiceByName(strTextConsoleWindow).getInstance();

    fConsole.setTitle(getClass().getName());
    fConsole.setReader(this);

    fFile = new FileEx();
    try {
      fFile.changePath(si.getFile().getFile().getAbsolutePath());
    } catch (Throwable a) {
    }

    writeln("Welcome to CShell.\nHave a nice work!\n"+
            fFile.getFile().getPath()+">");
  }

  private void writeln(String aStr) {
    Object[] o = new Object[1];
    o[0]=aStr;
    try { fConsole.writeData(o); }
    catch (Throwable a) {}
  }

  private void processCmd(String acmd) {
    IOutput out = fConsole;

    if (out != null)
    try {   //Catch exceptions
      //Remove leading chars if necessary
      int i = acmd.indexOf('>');
      if (i>=0) acmd = acmd.substring(i+1).trim();

      if (acmd.equalsIgnoreCase("exit")) {
         //Kill the console
         out = null;  //Also disables processing of all cmds in queue
         fConsole.setReader(null);
         fConsole = null;
         //Loose all references to outter world
         fFile = null;
         fSMgr = null;
         //And break processing of this command
         throw new Exception("Ending CShell...");
      }

      //Look for possible out-redirection to disk
      i = acmd.indexOf(">>");
      if (i>0) { //can't be first char
       out = new DiskOut(acmd.substring(i+2).trim());
       acmd = acmd.substring(0, i).trim();
      }

      //Let's count all parameters
      int j = 0, l;
      i = 0;
      do {
        i = acmd.indexOf(' ', i)+1;
        if (i>0) j++;
      } while (i>0);
      String[] arg = new String[j];
      //Array has been created=>fill it
      if (j>0) {
        i = acmd.indexOf(' ')+1;
        for (int k = 0; k<j-1; k++) {
          l = acmd.indexOf(' ', i)+1;
          arg[k] = acmd.substring(i, l).trim();
          i = l;
        }
        arg[j-1] = acmd.substring(i, acmd.length()).trim();

        //Cut the command line
        i = acmd.indexOf(' ');
        if (i>0) acmd = acmd.substring(0, i);
      }

      //check path presence
      if (acmd.lastIndexOf(".")<0) acmd = strBinDirPrefix+acmd;

      URL[] urls = new URL[0];
      URLClassLoader fLoader = new URLClassLoader(urls);

      fJOSSApp = (IJOSSApp) fLoader.loadClass(acmd).newInstance();
      fJOSSApp.main(new StartupInfo(fSMgr, arg, out, fFile));

    } catch (Throwable a) {writeln(a.getClass()+": ["+a.getMessage()+"]\n");};
    fJOSSApp = null;
  }

  public void onReadData(Object[] o) throws EJOSSError {
    if (fJOSSApp != null) fJOSSApp.onReadData(o);
      else {
         for (int i=0; i<o.length; i++)
            processCmd(o[i].toString());
         writeln(fFile.getFile().getPath()+">");
      }
  }
}