package joss.runtime.bin;

/**
 * Title:        Java Operating System Show
 * Description:  Example for the OS course at ZCU FAV KIV
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */

import joss.interfaces.*;
import joss.exceptions.*;

import java.io.*;

public class ls implements IJOSSApp {

  private IOutput fOut;

  private void writeln(String aStr) {
    Object[] o = new Object[1];
    o[0]=aStr;
    try { fOut.writeData(o); }
    catch (Throwable a) {}
  }

  protected void listDir(File aFile) {
    File[] fFiles = null;
    String tmp = "";

    if (aFile.exists() &&
        aFile.isDirectory() &&
        (fFiles = aFile.listFiles()) != null ) {
     for (int i=0; i<fFiles.length; i++)
       try {
         tmp = "";
         if (fFiles[i].isDirectory()) tmp = tmp+"D";
           else tmp = tmp+" ";

         if (fFiles[i].isHidden()) tmp = tmp+"H";
           else tmp = tmp+" ";

         writeln(tmp+"  "+fFiles[i].getName()+"\n");
       } catch(Throwable a) {}
    } else
     {
       writeln(aFile.getPath()+" can not be listed!\n");
     }
  }

  public void main(IStartupInfo si) {
    fOut = si.getOutput();
    Object[] o = si.getArgv();

    if (o.length>0) {
      for (int i = 0; i<o.length; i++)
        listDir(new File(o[i].toString()));
    } else
      listDir(si.getFile().getFile());
  }

   public void onReadData(Object[] o) throws EJOSSError {
   }

}