package joss.runtime;

/**
 * Title:        Java Operating System Show
 * Description:  Example for the OS course at ZCU FAV KIV
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */

import joss.interfaces.*;
import joss.exceptions.*;

import java.io.*;

public class FileEx implements IFileEx {

  private File fFile = new File("");

  public FileEx() {
   try {
     fFile = fFile.getCanonicalFile();
   } catch (Throwable a) {}
  }

  public File getFile() { return fFile; }

  public void changePath(String aChange) throws EJOSSError{
    File tmp = null;

    try {
      tmp = new File(fFile, aChange);
      if (!(tmp.exists()))
        throw new EJOSSError("Path doesn't exists!");

      fFile = tmp.getCanonicalFile();
    } catch (Throwable a) {
      throw(new EJOSSError("FileEx.changePath["+
                           a.getClass().getName()+": "+a.getMessage()+"]"));
    }
  }
}