package joss.microkernel;

/**
 * Title:        Java Operating System Show
 * Description:  Example for the OS course at ZCU FAV KIV
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */


import joss.interfaces.*;
import joss.exceptions.*;

import java.util.*;
import java.net.*;

public class ServiceManager implements IServiceManager{

  private TreeSet fServices = new TreeSet(); //Service wrapper's
  private URLClassLoader fLoader;            //Class loader

  public ServiceManager() {
   URL[] urls = new URL[0];
   fLoader = new URLClassLoader(urls);
  }

  public synchronized void installService(String serviceName)
      throws EJOSSError {
    //1. We have to load desired class
    //2. Verify that it implements the IService interface
    //3. Create its wrapper

    try
      {
       ServiceWrapper tmp = new ServiceWrapper((IService)
                                fLoader.loadClass(serviceName).newInstance());
       fServices.add(tmp);
      }
    catch (Throwable a) {
      throw(new EJOSSError("installService["+
                           a.getClass().getName()+": "+a.getMessage()+"]"));
    }
  }

  public synchronized IService getServiceByName(String serviceName) {
    return (IService) fServices.tailSet(new ServiceSearcher(serviceName)).first();
  }
}