package joss.interfaces;

/**
 * Title:        Java Operating System Show
 * Description:  Example for the OS course at ZCU FAV KIV
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */

 /**
  * This is JOSS' way how to pass parameters and access to services
  * to applications.
  */

public interface IStartupInfo {

 /**
  * Access to system services.
  */
  IServiceManager getServiceManager();

  /**
   *  "Access to generate outcoming traffic."
   */
   IOutput getOutput();

   /**
    * See main functions.
    */
   String[] getArgv();

   /**
    * Returns current directory. If app wants to change path of its launcher,
    * then it has to use this object. Nevertheless it depends on the launcher
    * if it will accept such change.
    */
    IFileEx getFile();

}