package joss.services;

import joss.interfaces.*;
import joss.runtime.*;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

/**
 * Title:        Java Operating System Show
 * Description:  Example for the OS course at ZCU FAV KIV
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */

public class Login extends JFrame implements mconst{
  JLabel jLabel2 = new JLabel();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JTextField jTextField1 = new JTextField();
  JComboBox cbxShell = new JComboBox();
  JPasswordField jPasswordField1 = new JPasswordField();
  JLabel jLabel4 = new JLabel();
  JLabel jLabel5 = new JLabel();
  JButton btnLogin = new JButton();
  JButton btnShutdown = new JButton();

  private IServiceManager fSMgr;

  public Login(IServiceManager aSM) {
    try {
      fSMgr = aSM;

      jbInit();

      cbxShell.addItem("joss.runtime.cshell.CShell");
      loadShellList();

      setTitle("JOSS Login");
      setSize(280, 170);
      show();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    this.setResizable(false);
    this.getContentPane().setLayout(null);
    jLabel2.setText("Password");
    jLabel2.setBounds(new Rectangle(6, 31, 66, 17));
    jLabel1.setText("User Name");
    jLabel1.setBounds(new Rectangle(6, 6, 67, 17));
    jLabel3.setToolTipText("");
    jLabel3.setText("Shell");
    jLabel3.setBounds(new Rectangle(6, 55, 41, 17));
    jTextField1.setText("");
    jTextField1.setBounds(new Rectangle(80, 6, 178, 21));
    cbxShell.setBounds(new Rectangle(80, 52, 178, 21));
    jPasswordField1.setText("jPasswordField1");
    jPasswordField1.setBounds(new Rectangle(80, 29, 178, 21));
    jLabel4.setText("Status");
    jLabel4.setBounds(new Rectangle(6, 80, 41, 17));
    jLabel5.setText("Ready");
    jLabel5.setBounds(new Rectangle(80, 79, 41, 17));
    btnLogin.setText("Login");
    btnLogin.setBounds(new Rectangle(25, 110, 110, 27));
    btnLogin.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        btnLogin_actionPerformed(e);
      }
    });
    btnShutdown.setText("Shutdown");
    btnShutdown.setBounds(new Rectangle(145, 110, 110, 27));
    btnShutdown.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        btnShutdown_actionPerformed(e);
      }
    });
    this.getContentPane().add(jLabel1, null);
    this.getContentPane().add(jTextField1, null);
    this.getContentPane().add(jPasswordField1, null);
    this.getContentPane().add(jLabel2, null);
    this.getContentPane().add(jLabel4, null);
    this.getContentPane().add(jLabel5, null);
    this.getContentPane().add(cbxShell, null);
    this.getContentPane().add(jLabel3, null);
    this.getContentPane().add(btnLogin, null);
    this.getContentPane().add(btnShutdown, null);
  }

  private void loadShellList() {
    try {
     //Construct all necessary streams - remeber their references for help to gc
     FileInputStream FIStream = new FileInputStream(strShellList);
     InputStreamReader ISReader = new InputStreamReader(FIStream);
     BufferedReader BReader = new BufferedReader(ISReader);
     String sname = "";

     while (BReader.ready())
       if ((sname = BReader.readLine().trim()) != null) cbxShell.addItem(sname);

     //Kill references
     BReader = null;
     ISReader = null;
     FIStream = null;

   } catch (Throwable a) { }
  }

  void btnShutdown_actionPerformed(ActionEvent e) {
     System.exit(0);
  }

  void btnLogin_actionPerformed(ActionEvent e) {
    //We have to try to create class specified by its name via the combo box
    try {
      URL[] urls = new URL[0];
      URLClassLoader ldr = new URLClassLoader(urls);
      StartupInfo si = new StartupInfo(fSMgr, null, null, new FileEx());

     Object tmp = ldr.loadClass(cbxShell.getSelectedItem().toString()).
                  newInstance();
     ((IJOSSApp) tmp).main(si);

    } catch (Throwable a) {
      System.out.println("["+a.getClass().getName()+": "+a.getMessage()+"]");
    }
  }
}