package joss.runtime;

/**
 * Title:        Java Operating System Show
 * Description:  Example for the OS course at ZCU FAV KIV
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */

import joss.interfaces.*;

public class StartupInfo implements IStartupInfo{

  private IServiceManager fsm;
  private String[] fargv;
  private IOutput fOut;
  private IFileEx fFile;

  public StartupInfo(IServiceManager sm, String[] argv,
                    IOutput aOut, IFileEx aFile) {
    fsm = sm;
    fargv = argv;
    fOut = aOut;
    fFile = aFile;
  }

  public IServiceManager getServiceManager() { return fsm; }

  public IOutput getOutput() { return fOut; }

  public String[] getArgv() { return fargv; }

  public IFileEx getFile() { return fFile; }
}