package joss.microkernel;

/**
 * Title:        Java Operating System Show
 * Description:  Example for the OS course at ZCU FAV KIV
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */

 /**
  * As we don't trust users of services, we will provide them only with wrappers
  * who implements the IService interface.
  */

import joss.interfaces.*;


public class ServiceWrapper implements IService, Comparable{
  //Comparable is to allow searching by name among services from Service Manager

  private IService FRealOne = null;  //The service we wrap

  public ServiceWrapper() {}; /*Forced by JBuilder 5.0 */

  public ServiceWrapper(IService realOne) {
     FRealOne = realOne;
  }

  public synchronized String getName() { return FRealOne.getName(); }

  public synchronized Object getInstance() { return FRealOne.getInstance(); }

  public synchronized int compareTo(Object o) {
    if /*(o.getClass().getName() == "String" )*/ (o instanceof String)
      return FRealOne.getName().compareTo(o);
      else return FRealOne.getName().compareTo(((ServiceWrapper) o).getName());
  }
}