package joss.microkernel;

/**
 * Title:        Java Operating System Show
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:      ZCU FAV KIV
 * @author Tomas Koutny
 * @version 1.0
 */

import joss.exceptions.*;
import joss.services.*;
import joss.interfaces.*;

import java.io.*;

/**
 * This class is responsible for loading:
 * 1. Service Manager (SM)                        //micro kernel
 * 2. All default services via Service Manager    //servers
 */
public class Loader implements mconst{

   private ServiceManager FServiceManager = new ServiceManager();
   private Login FLogin;

   public Loader() throws EJOSSError {
    System.out.println("Loading JOSS...");


    System.out.println(FServiceManager.getClass().getName()+" has been loaded");

    //OK, the real core has been loaded and it is fully operational now
    //=> load all services as they're specified in the load list
    try {
     //Construct all necessary streams - remeber their references for help to gc
     FileInputStream FIStream = new FileInputStream(strLoadList);
     InputStreamReader ISReader = new InputStreamReader(FIStream);
     BufferedReader BReader = new BufferedReader(ISReader);
     String sname = "";

     while (BReader.ready()) {
       try{
         //Read name of service to install
         if ((sname = BReader.readLine().trim()) == null) break;
         System.out.println("Attempting to install service '"+sname+"'...");
         FServiceManager.installService(sname);

       } catch(Throwable a) {
         System.out.println("Failed to install service '"+sname+"'! "+
                            a.getMessage());
       }
      }

     //Kill references
     BReader = null;
     ISReader = null;
     FIStream = null;

     //All services were loaded=>load the special one - the login
     System.out.println("Launching login...");
     FLogin = new Login(FServiceManager);

   } catch (Throwable a) {
       throw(new EJOSSError("Loader's Main: "+a.getMessage()));
   }
  }

    public static void main (String[] argv) {
      try { new Loader(); }
       catch(Exception e) { e.printStackTrace(); }
    }
}