/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsReceiver
implements Runnable {
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;
    private static final String className = CommsReceiver.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", className);

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, InputStream in) {
        this.in = new MqttInputStream(in);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        String methodName = "start";
        this.log.fine(className, "start", "855");
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.recThread = new Thread((Runnable)this, threadName);
                this.recThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            this.log.fine(className, "stop", "850");
            if (this.running) {
                this.running = false;
                if (!Thread.currentThread().equals(this.recThread)) {
                    try {
                        this.recThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.recThread = null;
        this.log.fine(className, "stop", "851");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String methodName = "run";
        MqttToken token = null;
        while (this.running && this.in != null) {
            try {
                this.log.fine(className, "run", "852");
                MqttWireMessage message = this.in.readMqttWireMessage();
                if (message instanceof MqttAck) {
                    token = this.tokenStore.getToken(message);
                    if (token != null) {
                        MqttToken mqttToken = token;
                        synchronized (mqttToken) {
                            this.clientState.notifyReceivedAck((MqttAck)message);
                            continue;
                        }
                    }
                    throw new MqttException(6);
                }
                this.clientState.notifyReceivedMsg(message);
            }
            catch (MqttException ex) {
                this.log.fine(className, "run", "856", null, ex);
                this.running = false;
                this.clientComms.shutdownConnection(token, ex);
            }
            catch (IOException ioe) {
                this.log.fine(className, "run", "853");
                this.running = false;
                if (this.clientComms.isDisconnecting()) continue;
                this.clientComms.shutdownConnection(token, new MqttException(32109, (Throwable)ioe));
            }
        }
        this.log.fine(className, "run", "854");
    }

    public boolean isRunning() {
        return this.running;
    }
}

