/*
 * Decompiled with CFR 0.152.
 */
package org.scriptcraftjs.canarymod;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.canarymod.Canary;
import net.canarymod.chat.MessageReceiver;
import net.canarymod.commandsys.Command;
import net.canarymod.commandsys.CommandListener;
import net.canarymod.commandsys.CommandOwner;
import net.canarymod.commandsys.TabComplete;
import net.canarymod.hook.Dispatcher;
import net.canarymod.hook.Hook;
import net.canarymod.plugin.Plugin;
import net.canarymod.plugin.PluginListener;
import net.canarymod.tasks.ServerTask;
import net.canarymod.tasks.TaskOwner;

public class ScriptCraftPlugin
extends Plugin
implements PluginListener,
CommandListener {
    public boolean canary = true;
    public boolean bukkit = false;
    private String NO_JAVASCRIPT_MESSAGE = "No JavaScript Engine available. ScriptCraft will not work without Javascript.";
    protected ScriptEngine engine = null;

    public void disable() {
        try {
            ((Invocable)((Object)this.engine)).invokeFunction("__onDisable", new Object[]{this.engine, this});
        }
        catch (Exception e) {
            this.getLogman().error(e.getMessage());
        }
    }

    public boolean enable() {
        try {
            ScriptEngineManager factory = new ScriptEngineManager();
            this.engine = factory.getEngineByName("JavaScript");
            if (this.engine == null) {
                this.getLogman().error(this.NO_JAVASCRIPT_MESSAGE);
            } else {
                Invocable inv = (Invocable)((Object)this.engine);
                InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("boot.js"));
                this.engine.eval(reader);
                inv.invokeFunction("__scboot", new Object[]{this, this.engine, ((Object)((Object)this)).getClass().getClassLoader()});
            }
            Canary.commands().registerCommands((CommandListener)this, (CommandOwner)this, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogman().error(e.getMessage());
        }
        return true;
    }

    public Dispatcher getDispatcher(final IDispatcher impl) {
        return new Dispatcher(){

            public void execute(PluginListener listener, Hook hook) {
                impl.execute(listener, hook);
            }
        };
    }

    public ServerTask createServerTask(Runnable runnable, long delay, boolean continuous) {
        return new ScriptCraftTask(runnable, (TaskOwner)this, delay, continuous);
    }

    private void executeCommand(MessageReceiver sender, String[] args) {
        Object jsResult = null;
        if (this.engine == null) {
            this.getLogman().error(this.NO_JAVASCRIPT_MESSAGE);
            return;
        }
        try {
            jsResult = ((Invocable)((Object)this.engine)).invokeFunction("__onCommand", sender, args);
        }
        catch (Exception se) {
            this.getLogman().error(se.toString());
            se.printStackTrace();
            sender.message(se.getMessage());
        }
        if (jsResult != null) {
            return;
        }
    }

    @Command(aliases={"js"}, description="Execute Javascript code", permissions={"scriptcraft.evaluate"}, toolTip="/js javascript expression")
    public void jsCommand(MessageReceiver sender, String[] args) {
        this.executeCommand(sender, args);
    }

    @Command(aliases={"jsp"}, description="Run javascript-provided command", permissions={""}, toolTip="/jsp command")
    public void jspCommand(MessageReceiver sender, String[] args) {
        this.executeCommand(sender, args);
    }

    private List<String> complete(MessageReceiver sender, String[] args, String cmd) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.engine == null) {
            this.getLogman().error(this.NO_JAVASCRIPT_MESSAGE);
            return null;
        }
        try {
            Invocable inv = (Invocable)((Object)this.engine);
            inv.invokeFunction("__onTabComplete", result, sender, args, cmd);
        }
        catch (Exception e) {
            sender.message(e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    @TabComplete(commands={"js"})
    public List<String> jsComplete(MessageReceiver sender, String[] args) {
        return this.complete(sender, args, "js");
    }

    @TabComplete(commands={"jsp"})
    public List<String> jspComplete(MessageReceiver sender, String[] args) {
        return this.complete(sender, args, "jsp");
    }

    static class ScriptCraftTask
    extends ServerTask {
        private Runnable runnable = null;

        public ScriptCraftTask(Runnable runnable, TaskOwner owner, long delay, boolean continuous) {
            super(owner, delay, continuous);
            this.runnable = runnable;
        }

        public void run() {
            this.runnable.run();
        }
    }

    public static interface IDispatcher {
        public void execute(PluginListener var1, Hook var2);
    }
}

