-- program PL0
-- compilator jazyka PL0 s generatorem ciloveho kodu

with TEXT_IO;

procedure PL0 is

  use TEXT_IO;
  package NAS_IO is new INTEGER_IO(INTEGER);
  use NAS_IO;


  NORW:constant:= 10;          -- pocet klicovych slov
  NMAX:constant:= 14;          -- maximalni pocet cislic v cisle
  TMAX:constant:= 100;         -- velikost tabulky identifikatoru
  AL:constant:= 10;            -- delka identifikatoru
  AMAX:constant:= 2048;        -- nejvyssi adresa
  MAXERR:constant:= 30;        -- maximalni pocet chyb
  LEVMAX:constant:= 3;         -- maximalni hloubka vnoreni
  CXMAX:constant:= 200;        -- velikost prostoru pro kod
  STACKSIZE:constant:= 500;

  EXIT_0, EXIT_1, EXIT_2, CONSTRAINT_ERROR: exception;

  type SYMBOL is (NUL,IDENT,NUMBER,PLUS,MINUS,TIMES,SLASH,ODDSYM,EQL,NEQ,LSS,
		LEQ,GTR,GEQ,LPAREN,RPAREN,COMMA,SEMICOLON,PERIOD,BECOMES,
		BEGINSYM,ENDSYM,IFSYM,THENSYM,WHILESYM,DOSYM,CALLSYM,
		CONSTSYM,VARSYM,PROCSYM);
  type ALFA is new STRING(1..AL);
  type OOBJECT is (OCONSTANT,OVARIABLE,OPROCEDURE);
  type SYMSET is array(SYMBOL) of INTEGER;
  type FCT is (LIT,OPR,LOD,STO,CAL,ING,JMP,JPC);      -- funkce

  type INSTRUCTION is record
		       F:FCT;       -- kod funkce
		       L:INTEGER;   -- uroven
		       A:INTEGER;   -- cast adresy
		   end record;

  --  lit 0,A        :uloz konstantu A do zasobniku
  --  opr 0,A        :proved instrukci A
  --  lod L,A        :uloz promenne L, A na vrchol zasobniku
  --  sto L,A        :zapis promennou L z vrcholu zasobniku do pameti
  --  cal L,A        :volej proceduru A z urovne L
  --  int 0,A        :zvys obsah T-registru o hodnotu A
  --  jmp 0,A        :proved skok na adresu A
  --  jpc 0,A        :proved podmineny skok na adresu A

  CH:CHARACTER;              -- posledni precteny znak
  TXPOM:INTEGER;             -- pomocna promenna
  SYM:SYMBOL;                -- posledni precteny symbol
  ID:ALFA;                   -- posledni precteny identifikator
  NUM:INTEGER;               -- posledni prectene cislo
  CC:INTEGER;                -- pocet znaku
  LL:INTEGER;                -- delka radku
  KK,ERR:INTEGER;
  CX:INTEGER;                -- pocitadlo adres

  LINE:array(0..80) of CHARACTER;
  A:ALFA;
  CODE:array(0..CXMAX) of INSTRUCTION;
  WORD:array(0..NORW) of ALFA :=("begin     ","call      ","const     ","do        ",
	    "end       ","if        ","odd       ","procedure ","then      ",
	    "var       ","while     ");
  WSYM:array(0..NORW) of SYMBOL :=(BEGINSYM,CALLSYM,CONSTSYM,DOSYM,ENDSYM,
			       IFSYM,ODDSYM,PROCSYM,THENSYM,VARSYM,WHILESYM);
  SSYM:array(CHARACTER) of SYMBOL;
  MNEMONIC:array(FCT) of STRING(1..5) :=("LIT  ","OPR  ","LOD  ",
				   "STO  ","CAL  ","INT  ","JMP  ","JMC  ");
  DECLBEGSYS,STATBEGSYS,FACBEGSYS:SYMSET;

  type ZAZNAM(KIND:OOBJECT:=OVARIABLE) is record
	 NAME:ALFA;
	 case KIND is
	   when OCONSTANT => VAL:INTEGER;
	   when OVARIABLE | OPROCEDURE => LEVEL,ADR,SIZE:INTEGER;
	 end case;
       end record;

  TABLE:array(0..TMAX) of ZAZNAM;

  CX0,B:INTEGER;
  S:array(0..STACKSIZE) of INTEGER;

  IVA, ZDROJ:FILE_TYPE;    -- pomocny soubor pro vypis generovaneho kodu
			   -- a tabulky symbolu
  POM:SYMSET;
  ZDROJAK:STRING(1..127);
  NULA:INTEGER;



procedure EXPRESSION(FSYS:in out SYMSET;TX,LEV:INTEGER);


procedure NULUJ(POM: in out SYMSET) is
begin
  for I in SYMBOL loop
    POM(I) := 0;
  end loop;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci nuluj");
end NULUJ;



procedure SJEDNOT(S1: in out SYMSET; S2: SYMSET) is
begin
  for I in SYMBOL loop
    if ((S1(I)=1) or (S2(I)=1)) then
      S1(I):= 1;
    end if;
  end loop;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci sjednot");
end SJEDNOT;



procedure LISTTABSYM is  -- pomocna fce pro vypis kon.tvaru tabulky symbolu
begin
  PUT_LINE(IVA,"");
  PUT_LINE(IVA,"");
  PUT_LINE(IVA,"Tabulka symbolu:");
  PUT_LINE(IVA,"***************");
  for I in 1..TXPOM loop
    PUT_LINE(IVA,"");
    PUT(IVA, I, 4);
    PUT(IVA,"  name: ");
    PUT(IVA,STRING(TABLE(I).NAME));
    case TABLE(I).KIND is
      when OCONSTANT =>
                       PUT(IVA," const val= ");
                       PUT(IVA,TABLE(I).VAL,4);
      when OVARIABLE =>
                       PUT(IVA," var   lev= ");
		       PUT(IVA,TABLE(I).LEVEL,4);
                       PUT(IVA,"  adr= ");
		       PUT(IVA,TABLE(I).ADR,4);
                       PUT(IVA,"  size= ");
                       PUT(IVA,TABLE(I).SIZE,4);
      when OPROCEDURE =>
                       PUT(IVA," proc  lev= ");
		       PUT(IVA,TABLE(I).LEVEL,4);
                       PUT(IVA,"  adr= ");
		       PUT(IVA,TABLE(I).ADR,4);
                       PUT(IVA,"  size= ");
                       PUT(IVA,TABLE(I).SIZE,4);
      end case;
    end loop;
      exception
    when CONSTRAINT_ERROR => PUT("c_e na konci listtabsym");
end LISTTABSYM;



procedure LISTGENCODE is
begin
  PUT_LINE(IVA,"");
  PUT_LINE(IVA,"generovany kod:");
  PUT_LINE(IVA,"***************");
  for I in 0..(CX - 2) loop
    PUT_LINE(IVA,"");
    PUT(IVA,I,WIDTH=>4);
    PUT(IVA," ");
    PUT(IVA,MNEMONIC(CODE(I).F));
    PUT(IVA," ");
    PUT(IVA,CODE(I).L,3);
    PUT(IVA," ");
    PUT(IVA,CODE(I).A,5);
  end loop;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci listgencode");
end LISTGENCODE;



procedure ERROR(N:INTEGER) is
begin
  PUT("****");
  for I in 0..(CC - 2) loop
    PUT(" ");
  end loop;
  PUT(N,2);
  PUT_LINE("");
  ERR := ERR + 1;
  if (ERR > MAXERR) then
    raise EXIT_0;
  end if;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci error");
end ERROR;



procedure GETCH is
begin
  if (CC = LL) then
    if END_OF_FILE(ZDROJ) then
       raise EXIT_2;
    end if;
    LL := 0;  CC := 0;
    for I in 0..80 loop
      GET(ZDROJ,CH);
      LINE(LL) := CH; LL := LL + 1;
      PUT(CH);
      exit when END_OF_FILE(ZDROJ);
    end loop;
    NEW_LINE;
    if (END_OF_FILE(ZDROJ)) then
        LINE(LL) := ' '; LL := LL + 1;
    end if;
    --LINE(LL) := ' '; LL := LL + 1;
  end if;
  CH := LINE(CC); CC := CC + 1;
  exception
    when CONSTRAINT_ERROR => PUT_LINE("c_e na konci getch");
end GETCH;

procedure GETSYM is
  I,J,K:INTEGER;
begin
  while (CH <= ' ')  loop
    GETCH;
  end loop;
  for I in 1..AL loop
    A(I) := ' ';
  end loop;
  if (CH in 'a'..'z') then        -- identifier or reserved word
    K := 1;
    loop
      if (K < AL) then
	A(K) := CH; K := K + 1;
      end if;
      GETCH;
      exit when ((CH not in 'a'..'z') and (CH not in '0'..'9'));
    end loop;
    ID := A; I := 0; J := NORW;
    loop
      K := (I + J) / 2;
      if (ID <= WORD(K)) then
	J := K - 1;
      end if;
      if (ID >=  WORD(K)) then
	I := K + 1;
      end if;
      exit when (I > J);
    end loop;
    if ((I - 1) > J) then
      SYM := WSYM(K);
    else
      SYM := IDENT;
    end if;
  elsif (CH in '0'..'9') then               -- number
    K := 0; NUM := 0; SYM := NUMBER;
    loop
      NUM := 10 * NUM + CHARACTER'POS(CH) - 48 ;
      K := K + 1;
      GETCH;
      exit when (CH not in '0'..'9');
    end loop;
    if (K > NMAX) then
      ERROR(30);
    end if;
  elsif (CH = ':') then
    GETCH;
    if (CH = '=') then
      SYM := BECOMES;
      GETCH;
    else
      SYM := NUL;
    end if;
  elsif (CH = '<') then
    GETCH;
    if (CH = '=') then
      SYM := LEQ;
      GETCH;
    else
      SYM := LSS;
    end if;
  elsif (CH = '>') then
    GETCH;
    if (CH = '=') then
      SYM := GEQ;
      GETCH;
    else
      SYM := GTR;
    end if;
  else
    SYM := SSYM(CH);
    GETCH;
  end if;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci getsym");
end GETSYM;



procedure GEN(X:FCT; Y,Z:INTEGER) is
begin
 if (CX > CXMAX) then
   raise EXIT_1;
 end if;
 CODE(CX).F := X;
 CODE(CX).L := Y;
 CODE(CX).A := Z;
 CX := CX + 1;
   exception
    when CONSTRAINT_ERROR => PUT("c_e na konci gen");
end GEN;



procedure TEST(S1,S2: in out SYMSET; N:INTEGER) is
  POM:SYMSET;
begin
  if (S1(SYM) = 0) then
    ERROR(N);
    NULUJ(POM);
    SJEDNOT(POM,S1);
    SJEDNOT(POM,S2);
    while (POM(SYM) = 0) loop
      GETSYM;
    end loop;
  end if;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci test");
end TEST;



procedure ENTER(K:OOBJECT;TX:in out INTEGER;LEV:INTEGER;DX:in out INTEGER) is
--  enter object into the table
begin
  TX := TX + 1;
  TXPOM := TX;
  case K is
    when OCONSTANT => if (NUM > AMAX) then
		       ERROR(31);
		       NUM := 0;
		     end if;
		     TABLE(TX) := ( OCONSTANT,ID,NUM);
    when OVARIABLE => TABLE(TX) := ( OVARIABLE,ID,LEV,DX,0);
		      DX := DX + 1;
    when OPROCEDURE => TABLE(TX) := ( OPROCEDURE,ID,LEV,0,0);
  end case;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci enter");
end ENTER;



function POSITION(ID:ALFA; TX:INTEGER) return INTEGER is
--  find identifier id in the table
  I:INTEGER;
begin
--  TABLE(1).NAME := ID; -- MS odstraneno, prepisoval se symbol v tabulce
  TABLE(0).NAME := ID; -- MS nahrazeno, ted se jiz neprepisuje
  I := TX;
  while (TABLE(I).NAME /= ID) loop
    I := I - 1;
  end loop;
  return I;
  exception
    when CONSTRAINT_ERROR => PUT("c_e na konci position"); return I;
end POSITION;

procedure CONSTDECLARATION(TX:in out INTEGER;LEV:INTEGER;DX:in out INTEGER) is
begin
  if (SYM = IDENT) then
    GETSYM;
    if ((SYM = EQL) or (SYM = BECOMES)) then
      if (SYM = BECOMES) then
	ERROR(1);
      end if;
      GETSYM;
      if (SYM = NUMBER) then
	ENTER(OCONSTANT,TX,LEV,DX);
	GETSYM;
      else
	ERROR(2);
      end if;
    else
      ERROR(3);
    end if;
  else
    ERROR(4);
  end if;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci constdeclaration");
end CONSTDECLARATION;



procedure VARDECLARATION(TX:in out INTEGER;LEV:INTEGER;DX:in out INTEGER) is
begin
  if (SYM = IDENT) then
    ENTER(OVARIABLE,TX,LEV,DX);
    GETSYM;
  else
    ERROR(4);
  end if;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci vardeclaration");
end VARDECLARATION;



procedure LISTCODE is       -- list code generated for this block
begin
  for I in CX0..(CX-1) loop
    PUT(I);
    PUT(" ");
    PUT(MNEMONIC(CODE(I).F));
    PUT(" ");
    PUT(CODE(I).L,3);
    PUT(" ");
    PUT(CODE(I).A,5);
    PUT_LINE("");
  end loop;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci listcode");
end LISTCODE;



procedure FACTOR(FSYS: in out SYMSET;TX,LEV:INTEGER) is
  I:INTEGER;
  POM:SYMSET;
begin
  TEST(FACBEGSYS,FSYS,24);
  while (FACBEGSYS(SYM) = 1) loop
    if (SYM = IDENT) then
      I := POSITION(ID,TX);
--      if (I = 0) then -- MS odstraneno - kvuli konvenci
      if (I < 1) then  -- MS vlozeno, jen formalita - kvuli konvenci
--	ERROR(1); -- MS odstraneno - spatne volani cisla chyby
	ERROR(11); -- MS vlozeno - chyba nedeklarovany identifikator
      else
	case (TABLE(I).KIND) is
	      when OCONSTANT => GEN(LIT,0,TABLE(I).VAL);
	      when OVARIABLE => GEN(LOD,LEV-TABLE(I).LEVEL,TABLE(I).ADR);
	      when OPROCEDURE => ERROR(21);
	end case;
      end if;
      GETSYM;
    elsif (SYM = NUMBER) then
      if (NUM > AMAX) then
	ERROR(31);
	NUM := 0;
      end if;
      GEN(LIT,0,NUM);
      GETSYM;
    elsif (SYM = LPAREN) then
      GETSYM;
      NULUJ(POM);
      SJEDNOT(POM,FSYS);
      POM(RPAREN) := 1;
      EXPRESSION(POM,TX,LEV);
      if (SYM = RPAREN) then
	GETSYM;
      else
	ERROR(22);
      end if;
    end if;
    NULUJ(POM);
    POM(LPAREN) := 1;
    TEST(FSYS,POM,23);
  end loop;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci factor");
end FACTOR;



procedure TERM(FSYS: in out SYMSET;TX,LEV:INTEGER) is
  MULOP:SYMBOL;
  POM:SYMSET;
begin
  NULUJ(POM);
  SJEDNOT(POM,FSYS);
  POM(TIMES) := 1; POM(SLASH) := 1;
  FACTOR(POM,TX,LEV);
  while ((SYM = TIMES) or (SYM = SLASH)) loop
    MULOP := SYM;
    GETSYM;
    SJEDNOT(POM,FSYS);
    POM(TIMES) := 1; POM(SLASH) := 1;
    FACTOR(POM,TX,LEV);
    if (MULOP = TIMES) then
      GEN(OPR,0,4);
    else
      GEN(OPR,0,5);
    end if;
  end loop;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci term");
end TERM;



procedure EXPRESSION(FSYS:in out SYMSET;TX,LEV:INTEGER) is
  ADDOP:SYMBOL;
  POM:SYMSET;
begin
  if ((SYM = PLUS) or (SYM = MINUS)) then
    ADDOP := SYM;
    GETSYM;
    NULUJ(POM);
    SJEDNOT(POM,FSYS);
    POM(PLUS) := 1; POM(MINUS) := 1;
    TERM(POM,TX,LEV);
    if (ADDOP = MINUS)  then
      GEN(OPR,0,1);
    end if;
  else
    NULUJ(POM);
    SJEDNOT(POM,FSYS);
    POM(PLUS) := 1; POM(MINUS) := 1;
    TERM(POM,TX,LEV);
  end if;
  while ((SYM = PLUS) or (SYM = MINUS)) loop
    ADDOP := SYM;
    GETSYM;
    NULUJ(POM);
    SJEDNOT(POM,FSYS);
    POM(PLUS) := 1; POM(MINUS) := 1;
    TERM(POM,TX,LEV);
    if (ADDOP = PLUS) then
      GEN(OPR,0,2);
    else
      GEN(OPR,0,3);
    end if;
  end loop;
  exception
    when CONSTRAINT_ERROR => PUT("c_e na konci expression");
end EXPRESSION;



procedure CONDITION(FSYS:in out SYMSET;TX,LEV:INTEGER) is
  RELOP:SYMBOL;
  POM:SYMSET;
begin
  if (SYM = ODDSYM) then
    GETSYM;
    EXPRESSION(FSYS,TX,LEV);
    GEN(OPR,0,6);
  else
    NULUJ(POM);
    SJEDNOT(POM,FSYS);
    POM(EQL..GEQ) := (1,1,1,1,1,1);
    EXPRESSION(POM,TX,LEV);
    if (SYM not in EQL..GEQ)  then
      ERROR(22);
    else
      RELOP := SYM;
      GETSYM;
      EXPRESSION(FSYS,TX,LEV);
      case RELOP is
	when EQL => GEN(OPR,0,8);
	when NEQ => GEN(OPR,0,9);
	when LSS => GEN(OPR,0,10);
	when GEQ => GEN(OPR,0,11);
	when GTR => GEN(OPR,0,12);
	when LEQ => GEN(OPR,0,13);
	when others => null;
      end case;
    end if;
  end if;
  exception
    when CONSTRAINT_ERROR => PUT("c_e na konci condition");
end CONDITION;



procedure STATEMENT(FSYS: in out SYMSET; TX,LEV:INTEGER) is
  CX1,CX2,I :INTEGER;
  POM:SYMSET;
begin
  if ((FSYS(SYM) = 0) and (SYM /= IDENT)) then
    ERROR(10);
    loop
      GETSYM;
      exit when FSYS(SYM) /= 0;
    end loop;
  end if;
  if (SYM = IDENT) then
    I := POSITION(ID,TX);
--    if (I < 0) then MS odstraneno - spatna mez 
    if (I < 1) then -- MS vlozeno - chyba odstranena
      ERROR(11);
    elsif (TABLE(I).KIND /= OVARIABLE) then  -- assigment to non-variable
      ERROR(12);
      I := 0;
    end if;
    GETSYM;
    if (SYM = BECOMES) then
      GETSYM;
    else
      ERROR(13);
    end if;
    EXPRESSION(FSYS,TX,LEV);
    if (I > 0) then
      GEN(STO,LEV-TABLE(I).LEVEL,TABLE(I).ADR);
    end if;
  elsif (SYM = CALLSYM) then
    begin
    GETSYM;
    I := POSITION(ID,TX); -- MS vlozeno - nastaveni pozice symbolu
    end;
    if (SYM /= IDENT) then
      ERROR(14);
--    elsif (I /= POSITION(ID,TX)) then -- MS odstraneno - chyba
    elsif (I < 1) then -- MS vlozeno - spravny zapis
      ERROR(11);
    else
      if (TABLE(I).KIND = OPROCEDURE) then
	GEN(CAL,LEV-TABLE(I).LEVEL,TABLE(I).ADR);
      else
	ERROR(15);
      end if;
      GETSYM;
    end if;
  elsif (SYM = IFSYM) then
    GETSYM;
    NULUJ(POM);
    SJEDNOT(POM,FSYS);
    POM(THENSYM) := 1; POM(DOSYM) := 1;
    CONDITION(POM,TX,LEV);
    if (SYM = THENSYM) then
      GETSYM;
    else
      ERROR(16);
    end if;
    CX1 := CX;
    GEN(JPC,0,0);
    STATEMENT(FSYS,TX,LEV);
    CODE(CX1).A := CX;
  elsif (SYM = BEGINSYM) then
    GETSYM;
    NULUJ(POM);
    SJEDNOT(POM,FSYS);
    POM(SEMICOLON) := 1; POM(ENDSYM) := 1;
    STATEMENT(POM,TX,LEV);
    while ((STATBEGSYS(SYM) /= 0) or (SYM = SEMICOLON)) loop
      if (SYM = SEMICOLON) then
	GETSYM;
      else
	ERROR(10);
      end if;
      SJEDNOT(POM,FSYS);
      POM(SEMICOLON) := 1; POM(ENDSYM) := 1;
      STATEMENT(POM,TX,LEV);
    end loop;
    if (SYM = ENDSYM) then
      GETSYM;
    else
      ERROR(17);
    end if;
  elsif (SYM = WHILESYM) then
    CX1 := CX;
    GETSYM;
    NULUJ(POM);
    SJEDNOT(POM,FSYS);
    POM(DOSYM) := 1;
    CONDITION(POM,TX,LEV);
    CX2 := CX;
    GEN(JPC,0,0);
    if (SYM = DOSYM) then
      GETSYM;
    else
      ERROR(18);
    end if;
    STATEMENT(FSYS,TX,LEV);
    GEN(JMP,0,CX1);
    CODE(CX2).A := CX;
  end if;
  TEST(FSYS,POM,19); 
  exception
    when CONSTRAINT_ERROR => PUT("c_e na konci statement");
end STATEMENT;



procedure BLOCK(LEV:INTEGER; TX:in out INTEGER;FSYS:in out SYMSET) is
  TX0,DX:INTEGER;
  POM:SYMSET;
begin
  DX := 3; TX0 := TX; TABLE(TX).ADR := CX;
  GEN(JMP,0,0);
  if (LEV > LEVMAX) then
    ERROR(32);
  end if;
  loop
    if (SYM = CONSTSYM) then
      PUT_LINE("CONST");
      GETSYM;
      loop
	CONSTDECLARATION(TX,LEV,DX);
	while (SYM = COMMA) loop
	  GETSYM;
	  CONSTDECLARATION(TX,LEV,DX);
	end loop;
	if (SYM = SEMICOLON) then
	  GETSYM;
	else
	  ERROR(5);
	end if;
	exit when (SYM /= IDENT);
      end loop;
    end if;
    if (SYM = VARSYM) then
      PUT_LINE("Var");
      GETSYM;
      VARDECLARATION(TX,LEV,DX);
      while (SYM = COMMA) loop
	GETSYM;
	VARDECLARATION(TX,LEV,DX);
      end loop;
      if (SYM = SEMICOLON) then
	GETSYM;
      else
	ERROR(5);
      end if;
    end if;
    while (SYM = PROCSYM) loop
      PUT_LINE("PROC");
      GETSYM;
      if (SYM = IDENT) then
	ENTER(OPROCEDURE,TX,LEV,DX);
	GETSYM;
      else
	ERROR(4);
      end if;
      if (SYM = SEMICOLON) then
	GETSYM;
      else
	ERROR(5);
      end if;
      NULUJ(POM);
      SJEDNOT(POM,FSYS);
      POM(SEMICOLON) := 1;
      BLOCK(LEV+1,TX,POM);
      if (SYM = SEMICOLON) then
	GETSYM;
	NULUJ(POM);
	SJEDNOT(POM,STATBEGSYS);
	POM(IDENT) := 1; POM(PROCSYM) := 1;
	TEST(POM,FSYS,6);
      else
	ERROR(5);
      end if;
    end loop;
    NULUJ(POM);
    SJEDNOT(POM,STATBEGSYS);
    POM(IDENT) := 1;
    TEST(POM,DECLBEGSYS,7);
  exit when (DECLBEGSYS(SYM) = 0);
  end loop;
  CODE(TABLE(TX0).ADR).A := CX;
  TABLE(TX0).ADR := CX;
  TABLE(TX0).SIZE := DX;
  CX0 := CX;
  GEN(ING,0,DX);
  NULUJ(POM);
  SJEDNOT(POM,FSYS);
  POM(SEMICOLON) := 1; POM(ENDSYM) := 1;
  STATEMENT(POM,TX,LEV);
  GEN(OPR,0,0);
  TEST(FSYS,POM,8);
  LISTCODE;
  exception
    when CONSTRAINT_ERROR => PUT("c_e na konci block");
end BLOCK;


function BASE(L:INTEGER) return INTEGER is
  L1,B1:INTEGER;
begin
  L1:=L;
  B1 := B;
  while (L1 > 0) loop
    B1 := S(B1);
    L1 := L1 - 1;
  end loop;
  return B1;
  exception
    when CONSTRAINT_ERROR => PUT("c_e na konci base"); 
    return B1;
end BASE;



procedure INTERPRET is
  P,T:INTEGER;
  I:INSTRUCTION;
begin
  PUT("START PL/0");
  NEW_LINE;
  T := 0; P := 0; S(1) := 0; S(2) := 0; S(3) := 0;B := 1;
  loop
    I := CODE(P); P := P + 1;
    case (I.F) is
      when LIT => T := T + 1; S(T) := I.A;
      when OPR => case (I.A) is
		    when 0 => T := B - 1;
			      P := S(T+3);
			      B := S(T+2);
		    when 1 => S(T) := -S(T);
		    when 2 => T := T - 1;
			      S(T) := S(T) + S(T+1);
		    when 3 => T := T - 1;
			      S(T) := S(T) - S(T+1);
		    when 4 => T := T - 1;
			      S(T) := S(T) * S(T+1);
		    when 5 => T := T - 1;
			      S(T) := S(T) / S(T+1);
		    when 6 => S(T) := S(T) mod 2;   -- funguje?
		    when 8 => T := T - 1;
			      if (S(T) = S(T+1)) then S(T) := 1;
			      else S(T) := 0; end if;
		    when 9 => T := T - 1;
			      if (S(T) /= S(T+1)) then S(T) := 1;
			      else S(T) := 0; end if;
		    when 10=> T := T - 1;
			      if (S(T) < S(T+1)) then S(T) := 1;
			      else S(T) := 0; end if;
		    when 11=> T := T - 1;
			      if (S(T) >= S(T+1)) then S(T) := 1;
			      else S(T) := 0; end if;
		    when 12=> T := T - 1;
			      if (S(T) > S(T+1)) then S(T) := 1;
			      else S(T) := 0; end if;
		    when 13=> T := T - 1;
			      if (S(T) <= S(T+1)) then S(T) := 1;
			      else S(T) := 0; end if;
		    when others => null;
		  end case;
      when LOD => T := T + 1;
		  S(T) := S(BASE(I.L) + I.A);
      when STO => S(BASE(I.L) + I.A) := S(T);
		  PUT(S(T));
		  PUT_LINE("");
                  T := T - 1;
      when CAL => S(T+1) := BASE(I.L);
		  S(T+2) := B;
		  S(T+3) := P;
		  B := T + 1;
		  P := I.A;
      when ING => T := T + I.A;
      when JMP => P := I.A;
      when JPC => if (S(T) = 0) then
		    P := I.A;
		  end if;
		  T := T - 1;
    end case;

    exit when (P = 0);
  end loop;
  PUT(" END PL/0");
  NEW_LINE;
    exception
    when CONSTRAINT_ERROR => PUT("c_e na konci interpret");
end INTERPRET;

begin
  PUT("Zadej jmeno souboru obsahujiciho zdrojovy text: ");
  --GET(ZDROJAK);
  PUT(CHARACTER'POS(ASCII.CR));
  PUT(CHARACTER'POS(ASCII.LF));
  CREATE(IVA,OUT_FILE,"TAB.SYM","");
  OPEN(ZDROJ,IN_FILE,"ZDROJ.PL0","");
  for CH in Character'Val(32)..Character'Val(127) loop
    SSYM(CH) := NUL;
  end loop;
  SSYM('+'):=PLUS;SSYM('-'):=MINUS;SSYM('*'):=TIMES;SSYM('/'):= SLASH;
  SSYM('('):=LPAREN;SSYM(')'):=RPAREN;SSYM('='):= EQL;SSYM(','):= COMMA;
  SSYM('.'):=PERIOD;SSYM('#'):=NEQ;SSYM('<'):=LSS;SSYM('>'):= GTR;
  SSYM(';'):=SEMICOLON;
  NULUJ(DECLBEGSYS);NULUJ(STATBEGSYS);NULUJ(FACBEGSYS);
  DECLBEGSYS(CONSTSYM):=1; DECLBEGSYS(VARSYM):=1; DECLBEGSYS(PROCSYM):=1;
  STATBEGSYS(BEGINSYM):=1; STATBEGSYS(CALLSYM):=1; STATBEGSYS(IFSYM):=1; STATBEGSYS(WHILESYM):=1;
  FACBEGSYS(IDENT):=1; FACBEGSYS(NUMBER):=1; FACBEGSYS(LPAREN):=1;
  ERR := 0; CC := 0; CX := 0; LL := 0; CH := ' '; KK := AL;
  GETSYM;
  NULUJ(POM);
  SJEDNOT(POM,DECLBEGSYS);
  SJEDNOT(POM,STATBEGSYS);
  POM(PERIOD) := 1;
  NULA:=0;
  BLOCK(0,NULA,POM);
  PUT_LINE("Compiled");
  if (SYM /= PERIOD) then
    ERROR(9);
  end if;
  LISTGENCODE;
  LISTTABSYM;
  if (ERR = 0) then
    PUT_LINE("no error in PL/0 program"); NEW_LINE;
    INTERPRET;
  else
    PUT(ERR,2);
    PUT_LINE(" error(s) in PL/0 program");
  end if;
  exception
    when EXIT_0 => null;
    when EXIT_1 => PUT("program too long");
    when EXIT_2 => PUT("program incompleted");
    when CONSTRAINT_ERROR => PUT("c_e na imp. miste osetreni");

  CLOSE(IVA);
  CLOSE(ZDROJ);
end PL0;
